DROP PROCEDURE [hips].[PatientMasterIhiUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 17 April 2012
-- Description:   Updates an existing record into the PatientMasterIhi Table
-- 19 Dec 2012 - Simon  - Removed PcehrAdvertised and AccessCodeRequiredId
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterIhiUpdate] 
(
	  @PatientMasterId INT
	, @Ihi VARCHAR(50) = NULL
	, @IhiStatusId INT
	, @RegisteredFamilyName VARCHAR(80)
	, @RegisteredGivenName VARCHAR(80)
	, @IhiRecordStatusId INT
	, @RegisteredSexId INT
	, @DateLastValidated DATETIME
	, @UserModified VARCHAR(256)
	, @DateModified datetime
)
AS
BEGIN
    SET NOCOUNT ON
 DECLARE @intErrorCode int

    SET @intErrorCode = 0
    -- Last one in wins - Always!
    --IF NOT EXISTS (SELECT TOP 1 [DateModified]
    --        	FROM [hips].[PatientMasterIhi]
				--WHERE [PatientMasterId] = @PatientMasterId AND [DateModified] = @DateModified)
    --BEGIN
    --    RAISERROR 50001 'Record has already been updated!'
    --    SET @intErrorCode = @@ERROR
    --END
 IF @intErrorCode = 0
    BEGIN
        UPDATE [hips].[PatientMasterIhi]
           SET [Ihi] = @Ihi
           	 , [IhiStatusId] = @IhiStatusId 
			 , [IhiRecordStatusId] = @IhiRecordStatusId 
			 , [RegisteredFamilyName] = @RegisteredFamilyName
			 , [RegisteredGivenName] = @RegisteredGivenName
			 , [RegisteredSexId] = @RegisteredSexId 
             , [DateLastValidated] = @DateLastValidated
             , [DateModified] = GetDate()
             , [UserModified] = @UserModified
         WHERE [PatientMasterId] = @PatientMasterId

        SELECT @intErrorCode = @@ERROR
    END

    IF @intErrorCode = 0
    BEGIN
		SELECT [PatientMasterId]
					 , [Ihi]
					 , [IhiStatusId]
					 , [IhiRecordStatusId]
					 , [RegisteredFamilyName]
					 , [RegisteredGivenName]
					 , [RegisteredSexId]
					 , [DateLastValidated]
					 , [DateCreated]
					 , [UserCreated]
					 , [DateModified]
					 , [UserModified]
					 FROM [hips].[PatientMasterIhi]            
		WHERE [PatientMasterId] = @PatientMasterId
    END

    RETURN(@intErrorCode)

END
GO

